/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class StorageCacheItem
implements IStorageCache<ItemStack> {
    public static final Consumer<INetwork> INVALIDATE = network -> network.getItemStorageCache().invalidate();
    private final INetwork network;
    private final CopyOnWriteArrayList<IStorage<ItemStack>> storages = new CopyOnWriteArrayList();
    private final IStackList<ItemStack> list = API.instance().createItemStackList();
    private final IStackList<ItemStack> craftables = API.instance().createItemStackList();
    private final List<IStorageCacheListener<ItemStack>> listeners = new LinkedList<IStorageCacheListener<ItemStack>>();
    private final List<StackListResult<ItemStack>> batchedChanges = new ArrayList<StackListResult<ItemStack>>();

    public StorageCacheItem(INetwork network) {
        this.network = network;
    }

    @Override
    public synchronized void invalidate() {
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.canUpdate() && node instanceof IStorageProvider).forEach(node -> ((IStorageProvider)((Object)node)).addItemStorages(this.storages));
        for (StackListEntry<ItemStack> stackListEntry : this.list.getStacks()) {
            this.batchedChanges.add(new StackListResult<ItemStack>(stackListEntry.getStack(), stackListEntry.getId(), -stackListEntry.getCount()));
        }
        this.list.clearCounts();
        this.sort();
        for (IStorage iStorage : this.storages) {
            if (iStorage.getAccessType() == AccessType.INSERT) continue;
            for (StackListEntry stack : iStorage.getEntries()) {
                if (stack == null || ((ItemStack)stack.getStack()).func_190926_b() || stack.getCount() <= 0L) continue;
                this.add((ItemStack)stack.getStack(), stack.getCount(), true);
            }
        }
        this.list.clearEmpty();
        this.listeners.forEach(IStorageCacheListener::onInvalidated);
        this.flush();
    }

    @Override
    public synchronized void add(@Nonnull ItemStack stack, long size, boolean batched) {
        StackListResult<ItemStack> result = this.list.add(stack, size);
        if (!batched) {
            this.listeners.forEach(l -> l.onChanged(result));
        } else {
            this.batchedChanges.add(result);
        }
    }

    @Override
    public synchronized void remove(@Nonnull ItemStack stack, long size, boolean batched) {
        StackListResult<ItemStack> result = this.list.remove(stack, size);
        if (result != null) {
            if (!batched) {
                this.listeners.forEach(l -> l.onChanged(result));
            } else {
                this.batchedChanges.add(result);
            }
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.batchedChanges.isEmpty()) {
            if (this.batchedChanges.size() > 1) {
                this.listeners.forEach(l -> l.onChangedBulk(this.batchedChanges));
            } else {
                this.batchedChanges.forEach(change -> this.listeners.forEach(l -> l.onChanged(change)));
            }
            this.batchedChanges.clear();
        }
    }

    @Override
    public void addListener(IStorageCacheListener<ItemStack> listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(IStorageCacheListener<ItemStack> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void reAttachListeners() {
        this.listeners.forEach(IStorageCacheListener::onAttached);
    }

    @Override
    public void sort() {
        this.storages.sort(IStorage.COMPARATOR);
    }

    @Override
    public IStackList<ItemStack> getList() {
        return this.list;
    }

    @Override
    public IStackList<ItemStack> getCraftablesList() {
        return this.craftables;
    }

    @Override
    public List<IStorage<ItemStack>> getStorages() {
        return this.storages;
    }
}

